<?php
/**
 * @package   solo
 * @copyright Copyright (c)2014-2025 Nicholas K. Dionysopoulos / Akeeba Ltd
 * @license   GNU General Public License version 3, or later
 */

namespace Solo\Model\Json\Task;

use Awf\Container\ContainerAwareInterface;
use Awf\Container\ContainerAwareTrait;
use Solo\Model\Json\TaskInterface;
use Solo\Model\Update;

/**
 * Get the update information
 */
class UpdateGetInformation implements TaskInterface, ContainerAwareInterface
{
	use ContainerAwareTrait;

	/**
	 * Return the JSON API task's name ("method" name). Remote clients will use it to call us.
	 *
	 * @return  string
	 */
	public function getMethodName()
	{
		return 'updateGetInformation';
	}

	/**
	 * Execute the JSON API task
	 *
	 * @param   array $parameters The parameters to this task
	 *
	 * @return  mixed
	 *
	 * @throws  \RuntimeException  In case of an error
	 */
	public function execute(array $parameters = array())
	{
		$filter = \Awf\Input\Filter::getInstance();

		// Get the passed configuration values
		$defConfig = array(
			'force' => 0
		);

		$defConfig = array_merge($defConfig, $parameters);

		$force = $filter->clean($defConfig['force'], 'bool');

		/** @var Update $update */
		$update = $this->getContainer()->mvcFactory->makeTempModel('Update');

		$updateInformation = $update->getUpdateInformation($force);

		return (object)$updateInformation;
	}
}
