<?php
/*
 * @package   bfNetwork
 * @copyright Copyright (C) 2011,2012,2013,2014,2015,2016,2017,2018,2019,2020,2021,2022 Blue Flame Digital Solutions Ltd. All rights reserved.
 * @license   GNU General Public License version 3 or later
 *
 * @see       https://mySites.guru/
 * @see       https://www.phil-taylor.com/
 *
 * @author    Phil Taylor / Blue Flame Digital Solutions Limited.
 *
 * bfNetwork is free software: you can redistribute it and/or modify
 * it under the terms of the GNU General Public License as published by
 * the Free Software Foundation, either version 3 of the License, or
 * (at your option) any later version.
 *
 * bfNetwork is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 *
 * You should have received a copy of the GNU General Public License
 * along with this package.  If not, see http://www.gnu.org/licenses/
 *
 * If you have any questions regarding this code, please contact phil@phil-taylor.com
 */

require 'bfEncrypt.php';

/**
 * If we have got here then we have already passed through decrypting the encrypted header and so we are sure we are now
 * secure and no one else cannot run the code below.
 */
final class bfBackup
{
    /**
     * We pass the command to run as a simple integer in our encrypted request this is mainly to speed up the decryption
     * process, plus its a single digit(or 2) rather than a huge string to remember :-).
     */
    private $_methods = array(
        1 => 'enableAkeebaFrontendBackup',
    );

    /**
     * Incoming decrypted vars from the request.
     *
     * @var stdClass
     */
    private $_dataObj;

    private $akeebaContainer;

    /**
     * I inject the request to the object.
     *
     * @param stdClass $dataObj
     */
    public function __construct($dataObj)
    {
        // init Joomla
        require 'bfInitWordpress.php';
        $this->akeebaContainer = require 'bfinitAkeeba.php';

        // Set the request vars
        $this->_dataObj = $dataObj;
    }

    /**
     * I'm the controller - I run methods based on the request integer.
     */
    public function run()
    {
        if (property_exists($this->_dataObj, 'c')) {
            $c = (int) $this->_dataObj->c;
            if (array_key_exists($c, $this->_methods)) {
                // call the right method
                $this->{$this->_methods[$c]} ();
            } else {
                // Die if an unknown function
                bfEncrypt::reply('error', 'No Such method #err1 - ' . $c);
            }
        } else {
            // Die if an unknown function
            bfEncrypt::reply('error', 'No Such method #err2');
        }
    }

    /**
     * If not enabled, then enable the Akeeba API Frontend using a secure secret word.
     */
    private function enableAkeebaFrontendBackup()
    {
        $activePlugins = get_option('active_plugins');

        if (is_string($activePlugins)) {
            $activePlugins = unserialize($activePlugins);
        }

        if (! in_array('akeebabackupwp/akeebabackupwp.php', $activePlugins)) {
            bfEncrypt::reply('success', array(
                'akeeba_installed' => false,
            ));
        }

        $secretWord = 'mySites.guru-' . file_get_contents('https://manage.mysites.guru/public/rand?_' . time());

        if (! $secretWord && function_exists('random_bytes') && function_exists('bin2hex')) {
            $secretWord = bin2hex(random_bytes(32));
        }

        $this->akeebaContainer->appConfig->set('options.frontend_secret_word', $secretWord);
        // Akeeba 7-
        $this->akeebaContainer->appConfig->set('options.frontend_enable', true);
        // Akeeba 7+
        $this->akeebaContainer->appConfig->set('options.jsonapi_enabled', true);

        $this->akeebaContainer->appConfig->saveConfiguration();

        bfEncrypt::reply('success', array(
            'akeeba_installed' => true,
            'secret'           => $secretWord,
        ));
    }
}

// init this class
$backupController = new bfBackup($dataObj);

// Run the tool method
$backupController->run();
