<?php
/*
 * @package   bfNetwork
 * @copyright Copyright (C) 2011,2012,2013,2014,2015,2016,2017,2018,2019,2020,2021,2022 Blue Flame Digital Solutions Ltd. All rights reserved.
 * @license   GNU General Public License version 3 or later
 *
 * @see       https://mySites.guru/
 * @see       https://www.phil-taylor.com/
 *
 * @author    Phil Taylor / Blue Flame Digital Solutions Limited.
 *
 * bfNetwork is free software: you can redistribute it and/or modify
 * it under the terms of the GNU General Public License as published by
 * the Free Software Foundation, either version 3 of the License, or
 * (at your option) any later version.
 *
 * bfNetwork is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 *
 * You should have received a copy of the GNU General Public License
 * along with this package.  If not, see http://www.gnu.org/licenses/
 *
 * If you have any questions regarding this code, please contact phil@phil-taylor.com
 */

if (! defined('BF_OK')) {
    echo 'BF_OK not ok';
    exit;
} // Exit if accessed directly

if (! class_exists('bfDb')) {
    class bfDb
    {
        private $query;

        /**
         * @see https://codex.wordpress.org/Class_Reference/wpdb
         *
         * @var wpdb
         */
        private $wpdb;

        public function __construct()
        {
            global $wpdb;
            $this->wpdb = $wpdb;

            // DEV!
            $this->wpdb->show_errors();
        }

        /**
         * @return wpdb
         */
        public function getAccess()
        {
            return $this->wpdb;
        }

        /**
         * @return bool
         */
        public function connected()
        {
            return true;
        }

        /**
         * @param $query
         */
        public function setQuery($query)
        {
            $this->query = $query;
        }

        /**
         * @param null $sql
         */
        public function loadObjectList($sql = null)
        {
            if (null !== $sql) {
                $this->setQuery($sql);
            }

            return $this->lastResult = $this->wpdb->get_results($this->getQuery(), OBJECT);
        }

        /**
         * @param null $sql
         */
        public function loadObject($sql = null)
        {
            if (null !== $sql) {
                $this->setQuery($sql);
            }

            $res = $this->wpdb->get_results($this->getQuery(), OBJECT);

            if (count($res)) {
                return $this->lastResult = $res[0];
            } else {
                return $this->lastResult = null;
            }
        }

        /**
         * @param $sql
         * @param $params
         */
        public function prepare($sql, $params)
        {
            return $this->wpdb->prepare($sql, $params);
        }

        public function loadResult($sql = null)
        {
            if (null !== $sql) {
                $this->setQuery($sql);
            }

            return $this->lastResult = $this->wpdb->get_var($this->getQuery());
        }

        public function execute($sql = null)
        {
            return $this->query($sql);
        }

        public function query($sql = null)
        {
            if (null !== $sql) {
                $this->setQuery($sql);
            }
            $this->lastResult = $this->wpdb->query($this->getQuery());

            return true;
        }

        public function quote($text)
        {
            return esc_sql($text);
        }

        public function getQuery()
        {
            return $this->prefix($this->query);
        }

        /**
         * @param int  $column_offset
         * @param null $sql
         */
        public function loadColumn($column_offset = 0, $sql = null)
        {
            if (null !== $sql) {
                $this->setQuery($sql);
            }

            return $this->lastResult = $this->wpdb->get_col($this->getQuery(), $column_offset);
        }

        /**
         * @param null $sql
         */
        public function loadResultArray($sql = null)
        {
            if (null !== $sql) {
                $this->setQuery($sql);
            }

            return $this->lastResult = $this->wpdb->get_results($this->getQuery(), ARRAY_A);
        }

        /**
         * @param $str
         */
        private function prefix($str)
        {
            return str_replace('#__', $this->wpdb->prefix, $str);
        }
    }
}
