<?php
/*
 * @package   bfNetwork
 * @copyright Copyright (C) 2011,2012,2013,2014,2015,2016,2017,2018,2019,2020,2021,2022 Blue Flame Digital Solutions Ltd. All rights reserved.
 * @license   GNU General Public License version 3 or later
 *
 * @see       https://mySites.guru/
 * @see       https://www.phil-taylor.com/
 *
 * @author    Phil Taylor / Blue Flame Digital Solutions Limited.
 *
 * bfNetwork is free software: you can redistribute it and/or modify
 * it under the terms of the GNU General Public License as published by
 * the Free Software Foundation, either version 3 of the License, or
 * (at your option) any later version.
 *
 * bfNetwork is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 *
 * You should have received a copy of the GNU General Public License
 * along with this package.  If not, see http://www.gnu.org/licenses/
 *
 * If you have any questions regarding this code, please contact phil@phil-taylor.com
 */

require 'bfEncrypt.php';
/*
 * If we have got here then we have already passed through decrypting
 * the encrypted header and so we are sure we are now secure and no one
 * else cannot run the code below.
 */

/*
 * Fake admin is logged in for 3rd party Integrated Updates - Having to deal with 3rd party code that doesnt think its outside WP
 * @see https://developer.wordpress.org/reference/functions/is_admin/
 */
if (! defined('WP_ADMIN')) {
    define('WP_ADMIN', true);
}

/*
 * fake being logged into WP Admin
 * @see https://developer.wordpress.org/reference/functions/is_user_logged_in/
 */
if (! function_exists('is_user_logged_in')) {
    function is_user_logged_in()
    {
        return true;
    }
}

/**
 * Our main toolset.
 */
final class bfUUM
{
    /**
     * We pass the command to run as a simple integer in our encrypted request this is mainly to speed up the decryption
     * process, plus its a single digit(or 2) rather than a huge string to remember :-).
     */
    private $_methods = array(
        1 => 'searchForString',
        2 => 'saveUser',
        3 => 'editUser',
    );

    /**
     * Pointer to the Database Object.
     *
     * @var
     */
    private $_db;

    /**
     * Incoming decrypted vars from the request.
     *
     * @var stdClass
     */
    private $_dataObj;

    /**
     * I inject the request to the object.
     *
     * @param stdClass $dataObj
     */
    public function __construct($dataObj)
    {
        // init
        require 'bfInitWordpress.php';
        require 'bfDb.php';

        // Set the request vars
        $this->_dataObj = $dataObj;

        // set the db object
        $this->_db = new bfDb();
    }

    /**
     * I run methods based on the request integer.
     */
    public function run()
    {
        if (property_exists($this->_dataObj, 'c')) {
            $c = (int) $this->_dataObj->c;
            if (array_key_exists($c, $this->_methods)) {
                bfLog::log('Calling methd ' . $this->_methods[$c]);
                // call the right method
                $this->{$this->_methods[$c]} ();
            } else {
                // Die if an unknown function
                bfEncrypt::reply('error', 'No Such method #err1 - ' . $c);
            }
        } else {
            // Die if an unknown function
            bfEncrypt::reply('error', 'No Such method #err2');
        }
    }

    // 1 = searchForString
    public function searchForString()
    {
        $sql = "SELECT ID as id, display_name as name, user_login as username, user_email as email
                    FROM #__users 
                    WHERE user_login LIKE '%{{Q}}%'
                    OR user_nicename LIKE '%{{Q}}%'
                    OR user_email LIKE '%{{Q}}%'
                    OR user_url LIKE '%{{Q}}%'
                    OR display_name LIKE '%{{Q}}%'
               ";

        $sql = str_replace('{{Q}}', esc_sql($this->_dataObj->uum_q), $sql);

        $this->_db->setQuery($sql);

        $users = $this->_db->loadObjectList();

        $data = array();
        foreach ($users as $user) {
            $user->roles = get_userdata($user->id)->roles;
            $data[]      = $user;
        }

        bfEncrypt::reply('success', array(
            'rows' => $data,
            'roles'=> $this->get_available_roles(),
        ));
    }

    //2 = saveUser
    public function saveUser()
    {
        try {
            $parts                  = array();
            $parts['user_nicename'] = '`user_nicename`="%s"';
            $parts['display_name']  = '`display_name`="%s"';
            $parts['user_login']    = '`user_login`="%s"';
            $parts['user_email']    = '`user_email`="%s"';
            $parts['user_pass']     = '`user_pass`="%s"';

            if ("" === trim($this->_dataObj->user->name)) {
                unset($parts['user_nicename']);
                unset($parts['display_name']);
            } else {
                $parts['user_nicename'] = sprintf($parts['user_nicename'], trim($this->_dataObj->user->name));
                $parts['display_name']  =   sprintf($parts['display_name'], trim($this->_dataObj->user->name));
            }

            if ("" === trim($this->_dataObj->user->username)) {
                unset($parts['user_login']);
            } else {
                $parts['user_login'] = sprintf($parts['user_login'], trim($this->_dataObj->user->username));
            }

            if ("" === trim($this->_dataObj->user->email)) {
                unset($parts['user_email']);
            } else {
                $parts['user_email'] = sprintf($parts['user_email'], trim($this->_dataObj->user->email));
            }

            if ("" === trim($this->_dataObj->user->password)) {
                unset($parts['user_pass']);
            } else {
                $password           = wp_hash_password($this->_dataObj->user->password);
                $parts['user_pass'] = sprintf($parts['user_pass'], $password);
            }

            $parts = implode(', ', $parts);

            $sql = 'UPDATE #__users set %s WHERE ID = %s LIMIT 1';
            $sql = sprintf($sql, $parts, (int) $this->_dataObj->user_id);

            $this->_db->setQuery($sql);

            if (! $this->_db->execute($sql)) {
                throw new \Exception($this->_db->getErrorMsg());
            }

            bfEncrypt::reply('success', array(
                'sql'    => $sql,
                'result' => 1,
            ));
        } catch (\Exception $exception) {
            bfEncrypt::reply('success', array(
                'result'       => 0,
                'errormessage' => $exception->getMessage(),
            ));
        }
    }

    //3 = editUser
    public function editUser()
    {
        try {
            $sql = 'SELECT ID as id, user_login as username, user_nicename as name, user_email as email FROM #__users WHERE id = "%s" LIMIT 1';
            $sql = sprintf($sql, (int) $this->_dataObj->id);

            $this->_db->setQuery($sql);

            if (! $user = $this->_db->loadObject()) {
                throw new \Exception($this->_db->getErrorMsg());
            }
        } catch (\Exception $exception) {
            bfEncrypt::reply('success', array(
                'result'       => 0,
                'errormessage' => $exception->getMessage(),
            ));
        }

        bfEncrypt::reply('success', json_decode(json_encode($user), true));
    }

    private function get_available_roles()
    {
        global $wp_roles;

        if (! isset($wp_roles)) {
            $wp_roles = new WP_Roles();
        }

        $editable_roles = get_editable_roles();
        foreach ($editable_roles as $role => $details) {
            $sub['role'] = esc_attr($role);
            $sub['name'] = translate_user_role($details['name']);
            $roles[]     = $sub;
        }
        return $roles;
    }
}
$object = new bfUUM($dataObj);

// init this class
$object->run();
